<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        $permissions = [
            'dashboard' => ['access-dashboard', 'dashboard-manage'],
            'destination' => ['destination-manage', 'destination-add', 'destination-edit', 'destination-delete'],
            'booking' => ['booking-manage', 'booking-add', 'booking-edit', 'booking-delete'],
            'review' => ['review-manage', 'review-add', 'review-edit', 'review-delete'],
            'package' => ['package-manage', 'package-add', 'package-edit', 'package-delete'],
            'category' => ['category-manage', 'category-add', 'category-edit', 'category-delete'],
            'country' => ['country-manage', 'country-add', 'country-edit', 'country-delete'],
            'activity' => ['activity-manage', 'activity-add', 'activity-edit', 'activity-delete'],
            'user' => ['user-manage', 'user-add', 'user-edit', 'user-delete', 'user-impersonate', 'user-access-dashboard'],
            'permission' => ['permission-manage', 'permission-add', 'permission-edit', 'permission-delete', 'permission-change'],
            'role' => ['role-manage', 'role-add', 'role-edit', 'role-delete'],
            'subscribe-plan' => ['subscribe-plan-manage', 'subscribe-plan-add', 'subscribe-plan-edit', 'subscribe-plan-delete'],
            'subscribed-user' => ['subs-user-manage', 'subs-user-add', 'subs-user-edit', 'subs-user-delete'],
            'checkout' => ['checkout-manage', 'checkout-add', 'checkout-edit', 'checkout-delete'],
            'blog' => ['blog-manage', 'blog-add', 'blog-edit', 'blog-delete'],
            'blog-category' => ['blog-category-manage', 'blog-category-add', 'blog-category-edit', 'blog-category-delete'],
            'faq-base' => ['faq-base-manage', 'faq-base-add', 'faq-base-edit', 'faq-base-delete'],
            'support' => ['support-manage', 'support-add', 'support-edit', 'support-delete'],
            // 'ticket' => ['ticket-manage', 'ticket-add', 'ticket-edit', 'ticket-delete'],
            'promotion' => ['promotion-manage', 'promotion-add', 'promotion-edit', 'promotion-delete'],
            // 'income-manage' => ['income-manage-manage', 'income-manage-add', 'income-manage-edit', 'income-manage-delete'],
            // 'income-category' => ['income-category-manage', 'income-category-add', 'income-category-edit', 'income-category-delete'],
            // 'expense-manage' => ['expense-manage', 'expense-manage-add', 'expense-manage-edit', 'expense-manage-delete'],
            // 'expense-category' => ['expense-category-manage', 'expense-category-add', 'expense-category-edit', 'expense-category-delete'],
            'pages' => ['pages-manage', 'pages-add', 'pages-edit', 'pages-delete'],
        ];

        foreach ($permissions as $module => $perms) {
            foreach ($perms as $name) {
                Permission::updateOrCreate([
                    'module' => $module,
                    'name' => $name,
                ], [
                    'removable' => 0,
                ]);
            }
        }

        $roles = [
            'Super Admin' => [],
            'admin' => Permission::all(),
            'user' => [],
            'agent' => [],
        ];

        foreach ($roles as $roleName => $rolePermissions) {
            $role = Role::updateOrCreate(['name' => $roleName], ['removable' => 0]);
            if (! empty($rolePermissions)) {
                $role->givePermissionTo($rolePermissions);
            }
        }
    }
}
